               
#include "PGA450.h"     		// Register Definitions
#include "PGA450_vars.h"     	// Variable Definitions

void external0_ISR (void) interrupt 0 using 1  {}
void external1_ISR (void) interrupt 2 using 1  {}
void timer0_ISR (void) interrupt 1 using 2 {}
void timer1_ISR (void) interrupt 3 using 2 {}
void serial_ISR (void) interrupt 4 	using 3 {}
void linSync_ISR (void) interrupt 8 using 3 {}

// * LIN SLAVE COMMAND ISR using Timer 0 *
void linPID_ISR (void) interrupt 5 	using 3{
	pid = LIN_PID&0x3F;
	switch (pid){
   		case 0x11: 								// Start Distance Measurement	(1 -> long (0.5 to 5 meters, else short (< 1meter))
			DATA_CNT = 1; 						// Number of bytes to be received
	  		LIN_CTRL = 0; 						//	Rx
	  		EI6 = 1; 							// Enable LIN Rx Interrupt
			break;

    	case 0x21: 								// Transmit 2 bytes to Master
	  		DATA_CNT = 2; 						// Number of bytes to be transmitted
	  		TX_DATA0 = 0x12;
			TX_DATA1 = 0x34;
	  		LIN_CTRL = 1; 						// Tx
	  		EI7 = 1; 							// Enable Tx Interrupt
			break;

		case 0x22: 								// Transmit 2 bytes to Master  (Echo)
	  		DATA_CNT = 2; 						// Number of bytes to be transmitted
	  		TX_DATA0 = TimeOfFlight.u8[0];
	  		TX_DATA1 = TimeOfFlight.u8[1];
	  		LIN_CTRL = 1; 						// Tx
	  		EI7 = 1; 							// Enable Tx Interrupt
			break;

		case 0x31:						 		// Write first 7 bytes of EEPROM for echo thresholds
			DATA_CNT = 7;						// LIN message will have 7 bytes
	  		LIN_CTRL = 0; 						//	Setup for LIN receive
	  		EI6 = 1; 							// Enable LIN Rx Interrupt						
			break;

		default:		 								// Un-Defined LIN Command
			break;
  }              
}

// * LIN/SCI RECEIVE DATA ISR using Timer0 *
void linSciRxData_ISR (void) interrupt 6 	using 3{
	union {
	   	unsigned short u16;
		unsigned char u8[2];
  	} FifoWritePointer;
	 union 
  	{
    	unsigned short u16;
		unsigned char u8[2];
  	}FRT_T1;
	union 
  	{
    	unsigned short u16;
		unsigned char u8[2];
  	}FRT_T2;

  	volatile unsigned short lcv;						// temporary loop count variable
	//volatile unsigned char EchoDuration;				// Valid echo only if echo above threshold for EchoDuration
	//volatile unsigned char EchoAboveThreshold;
	volatile unsigned char MaskEcho;					// Counter for masking data after an echo has been found
	volatile unsigned char DetectionThreshold;
	volatile unsigned char data EE_Data_Threshold[7];
	volatile unsigned char DetectIndex; 
	volatile unsigned char echo_data;

  	EI6 = 0; 									// Disable Rx Interrupt
  	switch (pid){  							// Switch to different tasks based on LIN_PID received 
 
		case 0x11:	 							// Long Distance Measurement
		
			if (RX_DATA0 == 1) {		// Long distance, load settings accordingly			
		 		PULSE_CNTA = 0x12;		// # pulses during burst
  				BLANKING_TIMER = 0xFF; 	// Waits #*16 uS after ECHO_EN = 1 to fill up FIFO (Ignores very close range data)
//				EchoDuration = 0x03;	// # of samples above threshold required to count as valid echo not noise
				FIFO_CTRL = 0x06;		// NO FIFO Rollover, 8 LSB
				CONTROL_1 = 0x01; 			// SAT threshold 300mV
				for (lcv=0;lcv<7;lcv++){								// Load Detection limits from EEPROM
					EE_Data_Threshold[lcv] = data_EEPROM[lcv] >> 4;		// Upper nibble contains the threshold for long distance measurements			
					}
				}
			else {	   					// Short distance, load settings accordingly
				PULSE_CNTA = 0x01;		// # pulses during burst
  				BLANKING_TIMER = 0x27; 	// Waits #*16 uS after ECHO_EN = 1 to fill up FIFO (Ignores very close range data)
//				EchoDuration = 0x03;	// # of samples above threshold required to count as valid echo not noise
				FIFO_CTRL = 0x07;		// NO FIFO Rollover, [10:3] mode
				CONTROL_1 = 0x01; 			// SAT threshold 300mV, LNA Gain = 400 V/V
				for (lcv=0;lcv<7;lcv++){								// Load Detection limits from EEPROM
				EE_Data_Threshold[lcv] = data_EEPROM[lcv] & 15;			// Lower nibble contains the threshold for short distance measurements			
					}
				}

			FifoWritePointer.u16 = 0;
			FRT_T1.u16 = 0;
			FRT_T2.u16 = 0;
			TimeOfFlight.u16 = 0;
			MaskEcho = 0;
			DetectIndex = 0;
//			EchoAboveThreshold = 0;								  
			
  			PWR_MODE = 0x03; 			// VREG_EN (D1)=1, ACTIVE_EN (D0)=1, ready for ultrasonic burst	  
      		EN_CTRL = 0x00;  			// Clear FIFO memory before burst     
      		BURST_MODE = 0x00;     		// Push Pull mode
      		BURST_ONA_MSB = 0x00;
     	 	BURST_ONA_LSB = 0xC8;  		// ON Time = 12.5us 16MHz/40KHz/2
      		BURST_OFFA_MSB = 0x00;
      		BURST_OFFA_LSB = 0xC8; 		// OFF Time = 12.5us
			DEADTIME = 0x05;			// Dead time between burst phases to limit shoot through current
			SAT_DEGLITCH = 0x09;   		// 2us per count || 1/58kHz (17.2uS)
			//CONTROL_1 = 0x01; 			// SAT threshold 300mV
			while(STATUS2 & 0x01 == 0){}// Wait for VREG to be ready			
	  		EN_CTRL = 0x85;       		// Enable Burst and saturation check, as well as log Free Running Timer

			//Record time
			FRT_T1.u8[0]=FRT_MSB;
			FRT_T1.u8[1]=FRT_LSB;
									
			while(STATUS2 & 0x02 == 0){}	// wait for decay done to be set			
			// If needed, user can check for the decay time capture here to check for an effective burst as a diagnostic

			PWR_MODE = 0x01;			// VREG disabled for better noise, ACTIVE mode remains enabled
			EN_CTRL = 0x0C;				// Enable Echo
			EA = 0;						// Disable interrupts during echo processing			
			DetectionThreshold = 255;
     		
			for(lcv=3;lcv<767;lcv++){

				 // Read FIFO Pointer coherently
	   			while ( lcv >= FifoWritePointer.u16 ){	     			
         			FifoWritePointer.u8[0] = FIFO_POINTER_MSB;
         			FifoWritePointer.u8[1] = FIFO_POINTER_LSB;
        			if ( FifoWritePointer.u8[0] != FIFO_POINTER_MSB ) { // Check if coherent	     	
           				FifoWritePointer.u8[0] = FIFO_POINTER_MSB;
           				FifoWritePointer.u8[1] = FIFO_POINTER_LSB;
	     		   }		 
	   			}  			 			

				if (RX_DATA0 == 1) {	// long distance  - threshold assignment)   
					if (lcv > 255) {					
						DetectionThreshold = 40;
						echo_data = data_FIFO[lcv] + data_FIFO[lcv-1] + data_FIFO[lcv-2] + data_FIFO[lcv-3];
						}
					else {
						echo_data = (data_FIFO[lcv] >> 2) + (data_FIFO[lcv-1] >> 2) + (data_FIFO[lcv-2] >> 2) + (data_FIFO[lcv-3] >> 2);
						if (lcv >= ((DetectIndex+1)<<5)) {
							DetectionThreshold = 12 + (EE_Data_Threshold[DetectIndex]<<3);
							DetectIndex++;							
							}	 				
						}				
					}
				else {			 		 // short distance  - threshold assignment)   
					if (lcv > 63) {					
						DetectionThreshold = 16;
						echo_data = data_FIFO[lcv] + data_FIFO[lcv-1] + data_FIFO[lcv-2] + data_FIFO[lcv-3];					
						}
					else {
						echo_data = (data_FIFO[lcv] >> 2) + (data_FIFO[lcv-1] >> 2) + (data_FIFO[lcv-2] >> 2) + (data_FIFO[lcv-3] >> 2);						
						if ((lcv >= ((DetectIndex+1)<<2)) && (DetectIndex < 6)) {
							DetectionThreshold = 4 + (EE_Data_Threshold[DetectIndex]<<4);
							DetectIndex++;
							}	 				
						}
					}

				if ( MaskEcho == 0){									
					if ( echo_data > DetectionThreshold) {		// Threshold compare
					
						EN_CTRL = 0x8C;			//log free running timer						
						FRT_T2.u8[0]=FRT_MSB;
						FRT_T2.u8[1]=FRT_LSB;
						if (FRT_T1.u16 > FRT_T2.u16) {
							TimeOfFlight.u16 = 65535+FRT_T2.u16-FRT_T1.u16;
						}
						else {
							TimeOfFlight.u16 = FRT_T2.u16-FRT_T1.u16;	
						}
						MaskEcho = 1;
					}
	   				
					//else{		
					//	EchoAboveThreshold=0;
					//}
				}	 					
	 		}			
			if (MaskEcho == 0) {
				TimeOfFlight.u16 = 65535;
			}
			PWR_MODE = 0x02; 		// VREG_EN (D1)=1, ACTIVE_EN (D0)=0, ready for ultrasonic burst
			EN_CTRL = 0x00;			// Clear all enables
			EA = 1;
			break;	   
 		 
		case 0x31:			  													// Write Threshold Table to EEPROM (7 bytes)
			EA = 0;
			data_EEPROM[0]=RX_DATA0;									  	
			data_EEPROM[1]=RX_DATA1;
			data_EEPROM[2]=RX_DATA2;
			data_EEPROM[3]=RX_DATA3;
			data_EEPROM[4]=RX_DATA4;
			data_EEPROM[5]=RX_DATA5;
			data_EEPROM[6]=RX_DATA6;
			EE_CTRL = 0x01;
			while (EE_CTRL == 0x01){}
			EA = 1;
			break;

		default:
			break;
  	}
}

void linSciTxData_ISR (void) interrupt 7 	using 3{
  LIN_CTRL = 0; // Rx
  //TX_DATA0 = 0x00;
  //TX_DATA1 = 0x00;
  //TX_DATA2 = 0x00;
  //TX_DATA3 = 0x00;
  //TX_DATA4 = 0x00;
  //TX_DATA5 = 0x00;
  //TX_DATA6 = 0x00;
  //TX_DATA7 = 0x00;

  EI7 = 0; // Disable Tx Interrupt
}


